<?php
/**
 * Clear Environment Cache
 * 
 * Run this script when you change .env values to clear all caches
 * and ensure the new values take effect immediately.
 * 
 * Usage: Visit http://versapro.test/clear_cache.php in your browser
 */

// Start session to clear it
session_start();

echo "<!DOCTYPE html>";
echo "<html><head><title>Cache Cleared</title>";
echo "<style>body{font-family:Arial;padding:40px;max-width:800px;margin:0 auto;}";
echo "h1{color:#28a745;}ul{line-height:2;}code{background:#f4f4f4;padding:2px 6px;border-radius:3px;}</style>";
echo "</head><body>";

echo "<h1>✅ Cache Clearing Tool</h1>";

$cleared = [];

// 1. Clear PHP Session
session_destroy();
$cleared[] = "PHP Session destroyed";

// 2. Clear OPcache (if enabled)
if (function_exists('opcache_reset')) {
    opcache_reset();
    $cleared[] = "OPcache cleared";
} else {
    $cleared[] = "OPcache not enabled (skip)";
}

// 3. Clear APCu cache (if enabled)
if (function_exists('apcu_clear_cache')) {
    apcu_clear_cache();
    $cleared[] = "APCu cache cleared";
} else {
    $cleared[] = "APCu not enabled (skip)";
}

// 4. Reload .env file
require_once(__DIR__ . '/config/env.php');
$cleared[] = ".env file reloaded";

// 5. Show current environment values
echo "<h2>Actions Performed:</h2>";
echo "<ul>";
foreach ($cleared as $action) {
    echo "<li>✅ $action</li>";
}
echo "</ul>";

// 6. Display current .env values (sanitized)
echo "<h2>Current Environment Configuration:</h2>";
echo "<table border='1' cellpadding='10' style='border-collapse:collapse;width:100%;'>";
echo "<tr><th>Variable</th><th>Value</th></tr>";

$env_vars = [
    'DB_SERVER',
    'DB_USERNAME',
    'DB_PASSWORD',
    'DB_NAME',
    'BASE_URL',
    'APP_ENV',
    'DEBUG_MODE',
    'DISPLAY_ERRORS'
];

foreach ($env_vars as $var) {
    $value = getenv($var);
    
    // Sanitize sensitive values
    if ($var === 'DB_PASSWORD' && !empty($value)) {
        $display_value = '****** (hidden)';
    } elseif (empty($value)) {
        $display_value = '<em>(empty)</em>';
    } else {
        $display_value = htmlspecialchars($value);
    }
    
    echo "<tr>";
    echo "<td><code>$var</code></td>";
    echo "<td>$display_value</td>";
    echo "</tr>";
}

echo "</table>";

// 7. Instructions
echo "<h2>What to do next:</h2>";
echo "<ol>";
echo "<li>Close all browser tabs for this site</li>";
echo "<li>Clear your browser cookies (Ctrl+Shift+Delete)</li>";
echo "<li>Restart your web server (Apache/Nginx) if values still don't update</li>";
echo "<li>Visit your site again</li>";
echo "</ol>";

echo "<h2>Quick Actions:</h2>";
echo "<p><a href='/' style='display:inline-block;padding:10px 20px;background:#007bff;color:white;text-decoration:none;border-radius:5px;'>Go to Home Page</a></p>";
echo "<p><a href='auth/login.php' style='display:inline-block;padding:10px 20px;background:#28a745;color:white;text-decoration:none;border-radius:5px;'>Go to Login</a></p>";

echo "<hr>";
echo "<p><small>Last cleared: " . date('Y-m-d H:i:s') . "</small></p>";

echo "</body></html>";
?>
